/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.bollinger;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsMiddleIndicator;
import org.ta4j.core.num.Num;

public class BollingerBandsLowerIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final BollingerBandsMiddleIndicator bbm;
    private final Num k;

    public BollingerBandsLowerIndicator(BollingerBandsMiddleIndicator bbm, Indicator<Num> indicator) {
        this(bbm, indicator, bbm.getBarSeries().numOf(2));
    }

    public BollingerBandsLowerIndicator(BollingerBandsMiddleIndicator bbm, Indicator<Num> indicator, Num k) {
        super(indicator);
        this.bbm = bbm;
        this.indicator = indicator;
        this.k = k;
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.bbm.getValue(index)).minus(this.indicator.getValue(index).multipliedBy(this.k));
    }

    public Num getK() {
        return this.k;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "k: " + this.k + "deviation: " + this.indicator + "series: " + this.bbm;
    }
}

