/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.bollinger;

import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsLowerIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsMiddleIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsUpperIndicator;
import org.ta4j.core.num.Num;

public class BollingerBandWidthIndicator
extends CachedIndicator<Num> {
    private final BollingerBandsUpperIndicator bbu;
    private final BollingerBandsMiddleIndicator bbm;
    private final BollingerBandsLowerIndicator bbl;
    private final Num hundred;

    public BollingerBandWidthIndicator(BollingerBandsUpperIndicator bbu, BollingerBandsMiddleIndicator bbm, BollingerBandsLowerIndicator bbl) {
        super(bbm.getBarSeries());
        this.bbu = bbu;
        this.bbm = bbm;
        this.bbl = bbl;
        this.hundred = bbm.getBarSeries().numOf(100);
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.bbu.getValue(index)).minus((Num)this.bbl.getValue(index)).dividedBy((Num)this.bbm.getValue(index)).multipliedBy(this.hundred);
    }
}

