/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.adx;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.ATRIndicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.MMAIndicator;
import org.ta4j.core.indicators.helpers.PlusDMIndicator;
import org.ta4j.core.num.Num;

public class PlusDIIndicator
extends CachedIndicator<Num> {
    private final MMAIndicator avgPlusDMIndicator;
    private final ATRIndicator atrIndicator;
    private final int barCount;

    public PlusDIIndicator(BarSeries series, int barCount) {
        super(series);
        this.avgPlusDMIndicator = new MMAIndicator(new PlusDMIndicator(series), barCount);
        this.atrIndicator = new ATRIndicator(series, barCount);
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.avgPlusDMIndicator.getValue(index)).dividedBy((Num)this.atrIndicator.getValue(index)).multipliedBy(this.numOf(100));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "barCount: " + this.barCount;
    }
}

