/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.adx;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.ATRIndicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.MMAIndicator;
import org.ta4j.core.indicators.helpers.MinusDMIndicator;
import org.ta4j.core.num.Num;

public class MinusDIIndicator
extends CachedIndicator<Num> {
    private final MMAIndicator avgMinusDMIndicator;
    private final ATRIndicator atrIndicator;
    private final int barCount;

    public MinusDIIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
        this.avgMinusDMIndicator = new MMAIndicator(new MinusDMIndicator(series), barCount);
        this.atrIndicator = new ATRIndicator(series, barCount);
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.avgMinusDMIndicator.getValue(index)).dividedBy((Num)this.atrIndicator.getValue(index)).multipliedBy(this.numOf(100));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

