/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.num.Num;

public class ZLEMAIndicator
extends RecursiveCachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final int barCount;
    private final Num k;
    private final int lag;

    public ZLEMAIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
        this.k = this.numOf(2).dividedBy(this.numOf(barCount + 1));
        this.lag = (barCount - 1) / 2;
    }

    @Override
    protected Num calculate(int index) {
        if (index + 1 < this.barCount) {
            return (Num)new SMAIndicator(this.indicator, this.barCount).getValue(index);
        }
        if (index == 0) {
            return this.indicator.getValue(0);
        }
        Num zlemaPrev = (Num)this.getValue(index - 1);
        return this.k.multipliedBy(this.numOf(2).multipliedBy(this.indicator.getValue(index)).minus(this.indicator.getValue(index - this.lag))).plus(this.numOf(1).minus(this.k).multipliedBy(zlemaPrev));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

