/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.ClosePriceIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.num.Num;

public class WilliamsRIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> closePriceIndicator;
    private final int barCount;
    private final HighPriceIndicator highPriceIndicator;
    private final LowPriceIndicator lowPriceIndicator;
    private final Num multiplier;

    public WilliamsRIndicator(BarSeries barSeries, int barCount) {
        this(new ClosePriceIndicator(barSeries), barCount, new HighPriceIndicator(barSeries), new LowPriceIndicator(barSeries));
    }

    public WilliamsRIndicator(ClosePriceIndicator closePriceIndicator, int barCount, HighPriceIndicator highPriceIndicator, LowPriceIndicator lowPriceIndicator) {
        super(closePriceIndicator);
        this.closePriceIndicator = closePriceIndicator;
        this.barCount = barCount;
        this.highPriceIndicator = highPriceIndicator;
        this.lowPriceIndicator = lowPriceIndicator;
        this.multiplier = this.numOf(-100);
    }

    @Override
    protected Num calculate(int index) {
        HighestValueIndicator highestHigh = new HighestValueIndicator(this.highPriceIndicator, this.barCount);
        LowestValueIndicator lowestMin = new LowestValueIndicator(this.lowPriceIndicator, this.barCount);
        Num highestHighPrice = (Num)highestHigh.getValue(index);
        Num lowestLowPrice = (Num)lowestMin.getValue(index);
        return highestHighPrice.minus(this.closePriceIndicator.getValue(index)).dividedBy(highestHighPrice.minus(lowestLowPrice)).multipliedBy(this.multiplier);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

