/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class WMAIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = -1610206345404758687L;
    private final int barCount;
    private final Indicator<Num> indicator;

    public WMAIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        if (index == 0) {
            return this.indicator.getValue(0);
        }
        Num value = this.numOf(0);
        if (index - this.barCount < 0) {
            for (int i = index + 1; i > 0; --i) {
                value = value.plus(this.numOf(i).multipliedBy(this.indicator.getValue(i - 1)));
            }
            return value.dividedBy(this.numOf((index + 1) * (index + 2) / 2));
        }
        int actualIndex = index;
        for (int i = this.barCount; i > 0; --i) {
            value = value.plus(this.numOf(i).multipliedBy(this.indicator.getValue(actualIndex)));
            --actualIndex;
        }
        return value.dividedBy(this.numOf(this.barCount * (this.barCount + 1) / 2));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

