/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.num.Num;

public class UlcerIndexIndicator
extends CachedIndicator<Num> {
    private Indicator<Num> indicator;
    private HighestValueIndicator highestValueInd;
    private int barCount;

    public UlcerIndexIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
        this.highestValueInd = new HighestValueIndicator(indicator, barCount);
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        int numberOfObservations = index - startIndex + 1;
        Num squaredAverage = this.numOf(0);
        for (int i = startIndex; i <= index; ++i) {
            Num currentValue = this.indicator.getValue(i);
            Num highestValue = (Num)this.highestValueInd.getValue(i);
            Num percentageDrawdown = currentValue.minus(highestValue).dividedBy(highestValue).multipliedBy(this.numOf(100));
            squaredAverage = squaredAverage.plus(percentageDrawdown.pow(2));
        }
        squaredAverage = squaredAverage.dividedBy(this.numOf(numberOfObservations));
        return squaredAverage.sqrt();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

