/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.EMAIndicator;
import org.ta4j.core.num.Num;

public class TripleEMAIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = -3091675249185831978L;
    private final int barCount;
    private final EMAIndicator ema;
    private final EMAIndicator emaEma;
    private final EMAIndicator emaEmaEma;

    public TripleEMAIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.barCount = barCount;
        this.ema = new EMAIndicator(indicator, barCount);
        this.emaEma = new EMAIndicator(this.ema, barCount);
        this.emaEmaEma = new EMAIndicator(this.emaEma, barCount);
    }

    @Override
    protected Num calculate(int index) {
        return this.numOf(3).multipliedBy(((Num)this.ema.getValue(index)).minus((Num)this.emaEma.getValue(index))).plus((Num)this.emaEmaEma.getValue(index));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

