/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class SMAIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = 653601631245729997L;
    private final Indicator<Num> indicator;
    private final int barCount;

    public SMAIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        Num sum = this.numOf(0);
        for (int i = Math.max(0, index - this.barCount + 1); i <= index; ++i) {
            sum = sum.plus(this.indicator.getValue(i));
        }
        int realBarCount = Math.min(this.barCount, index + 1);
        return sum.dividedBy(this.numOf(realBarCount));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

