/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;

public abstract class RecursiveCachedIndicator<T>
extends CachedIndicator<T> {
    private static final int RECURSION_THRESHOLD = 100;

    public RecursiveCachedIndicator(BarSeries series) {
        super(series);
    }

    public RecursiveCachedIndicator(Indicator<?> indicator) {
        this(indicator.getBarSeries());
    }

    @Override
    public T getValue(int index) {
        int removedBarsCount;
        int startIndex;
        int seriesEndIndex;
        BarSeries series = this.getBarSeries();
        if (series != null && index <= (seriesEndIndex = series.getEndIndex()) && index - (startIndex = Math.max(removedBarsCount = series.getRemovedBarsCount(), this.highestResultIndex)) > 100) {
            for (int prevIdx = startIndex; prevIdx < index; ++prevIdx) {
                super.getValue(prevIdx);
            }
        }
        return super.getValue(index);
    }
}

