/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.ATRIndicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class RWILowIndicator
extends CachedIndicator<Num> {
    private final int barCount;

    public RWILowIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        if (index - this.barCount + 1 < this.getBarSeries().getBeginIndex()) {
            return NaN.NaN;
        }
        Num minRWIL = this.numOf(0);
        for (int n = 2; n <= this.barCount; ++n) {
            minRWIL = minRWIL.max(this.calcRWIHFor(index, n));
        }
        return minRWIL;
    }

    private Num calcRWIHFor(int index, int n) {
        BarSeries series = this.getBarSeries();
        Num low = series.getBar(index).getLowPrice();
        Num highN = series.getBar(index + 1 - n).getHighPrice();
        Num atrN = (Num)new ATRIndicator(series, n).getValue(index);
        Num sqrtN = this.numOf(n).sqrt();
        return highN.minus(low).dividedBy(atrN.multipliedBy(sqrtN));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

