/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.MMAIndicator;
import org.ta4j.core.indicators.helpers.GainIndicator;
import org.ta4j.core.indicators.helpers.LossIndicator;
import org.ta4j.core.num.Num;

public class RSIIndicator
extends CachedIndicator<Num> {
    private final MMAIndicator averageGainIndicator;
    private final MMAIndicator averageLossIndicator;

    public RSIIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.averageGainIndicator = new MMAIndicator(new GainIndicator(indicator), barCount);
        this.averageLossIndicator = new MMAIndicator(new LossIndicator(indicator), barCount);
    }

    @Override
    protected Num calculate(int index) {
        Num averageGain = (Num)this.averageGainIndicator.getValue(index);
        Num averageLoss = (Num)this.averageLossIndicator.getValue(index);
        if (averageLoss.isZero()) {
            if (averageGain.isZero()) {
                return this.numOf(0);
            }
            return this.numOf(100);
        }
        Num relativeStrength = averageGain.dividedBy(averageLoss);
        return this.numOf(100).minus(this.numOf(100).dividedBy(this.numOf(1).plus(relativeStrength)));
    }
}

