/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class ParabolicSarIndicator
extends RecursiveCachedIndicator<Num> {
    private final Num maxAcceleration;
    private final Num accelerationIncrement;
    private final Num accelerationStart;
    private Num accelerationFactor;
    private boolean currentTrend;
    private int startTrendIndex = 0;
    private LowPriceIndicator lowPriceIndicator;
    private HighPriceIndicator highPriceIndicator;
    private Num currentExtremePoint;
    private Num minMaxExtremePoint;

    public ParabolicSarIndicator(BarSeries series) {
        this(series, series.numOf(0.02), series.numOf(0.2), series.numOf(0.02));
    }

    public ParabolicSarIndicator(BarSeries series, Num aF, Num maxA) {
        this(series, aF, maxA, series.numOf(0.02));
    }

    public ParabolicSarIndicator(BarSeries series, Num aF, Num maxA, Num increment) {
        super(series);
        this.highPriceIndicator = new HighPriceIndicator(series);
        this.lowPriceIndicator = new LowPriceIndicator(series);
        this.maxAcceleration = maxA;
        this.accelerationFactor = aF;
        this.accelerationIncrement = increment;
        this.accelerationStart = aF;
    }

    @Override
    protected Num calculate(int index) {
        Num sar = NaN.NaN;
        if (index == this.getBarSeries().getBeginIndex()) {
            return sar;
        }
        if (index == this.getBarSeries().getBeginIndex() + 1) {
            this.currentTrend = this.getBarSeries().getBar(this.getBarSeries().getBeginIndex()).getClosePrice().isLessThan(this.getBarSeries().getBar(index).getClosePrice());
            this.minMaxExtremePoint = !this.currentTrend ? (this.currentExtremePoint = (sar = (Num)this.highPriceIndicator.getValue(index))) : (this.currentExtremePoint = (sar = (Num)this.lowPriceIndicator.getValue(index)));
            return sar;
        }
        Num priorSar = (Num)this.getValue(index - 1);
        if (this.currentTrend) {
            sar = priorSar.plus(this.accelerationFactor.multipliedBy(this.currentExtremePoint.minus(priorSar)));
            this.currentTrend = ((Num)this.lowPriceIndicator.getValue(index)).isGreaterThan(sar);
            if (!this.currentTrend) {
                sar = this.minMaxExtremePoint;
                this.currentTrend = false;
                this.startTrendIndex = index;
                this.accelerationFactor = this.accelerationStart;
                this.minMaxExtremePoint = this.currentExtremePoint = this.getBarSeries().getBar(index).getLowPrice();
            } else {
                this.currentExtremePoint = (Num)new HighestValueIndicator(this.highPriceIndicator, index - this.startTrendIndex).getValue(index);
                if (this.currentExtremePoint.isGreaterThan(this.minMaxExtremePoint)) {
                    this.incrementAcceleration();
                    this.minMaxExtremePoint = this.currentExtremePoint;
                }
            }
        } else {
            sar = priorSar.minus(this.accelerationFactor.multipliedBy(priorSar.minus(this.currentExtremePoint)));
            this.currentTrend = ((Num)this.highPriceIndicator.getValue(index)).isGreaterThanOrEqual(sar);
            if (this.currentTrend) {
                sar = this.minMaxExtremePoint;
                this.accelerationFactor = this.accelerationStart;
                this.startTrendIndex = index;
                this.minMaxExtremePoint = this.currentExtremePoint = this.getBarSeries().getBar(index).getHighPrice();
            } else {
                this.currentExtremePoint = (Num)new LowestValueIndicator(this.lowPriceIndicator, index - this.startTrendIndex).getValue(index);
                if (this.currentExtremePoint.isLessThan(this.minMaxExtremePoint)) {
                    this.incrementAcceleration();
                    this.minMaxExtremePoint = this.currentExtremePoint;
                }
            }
        }
        return sar;
    }

    private void incrementAcceleration() {
        this.accelerationFactor = this.accelerationFactor.isGreaterThanOrEqual(this.maxAcceleration) ? this.maxAcceleration : this.accelerationFactor.plus(this.accelerationIncrement);
    }
}

