/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.EMAIndicator;
import org.ta4j.core.num.Num;

public class PPOIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = -4337731034816094765L;
    private final EMAIndicator shortTermEma;
    private final EMAIndicator longTermEma;

    public PPOIndicator(Indicator<Num> indicator) {
        this(indicator, 12, 26);
    }

    public PPOIndicator(Indicator<Num> indicator, int shortBarCount, int longBarCount) {
        super(indicator);
        if (shortBarCount > longBarCount) {
            throw new IllegalArgumentException("Long term period count must be greater than short term period count");
        }
        this.shortTermEma = new EMAIndicator(indicator, shortBarCount);
        this.longTermEma = new EMAIndicator(indicator, longBarCount);
    }

    @Override
    protected Num calculate(int index) {
        Num shortEmaValue = (Num)this.shortTermEma.getValue(index);
        Num longEmaValue = (Num)this.longTermEma.getValue(index);
        return shortEmaValue.minus(longEmaValue).dividedBy(longEmaValue).multipliedBy(this.numOf(100));
    }
}

