/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.EMAIndicator;
import org.ta4j.core.indicators.helpers.DifferenceIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.num.Num;

public class MassIndexIndicator
extends CachedIndicator<Num> {
    private final EMAIndicator singleEma;
    private final EMAIndicator doubleEma;
    private final int barCount;

    public MassIndexIndicator(BarSeries series, int emaBarCount, int barCount) {
        super(series);
        DifferenceIndicator highLowDifferential = new DifferenceIndicator(new HighPriceIndicator(series), new LowPriceIndicator(series));
        this.singleEma = new EMAIndicator(highLowDifferential, emaBarCount);
        this.doubleEma = new EMAIndicator(this.singleEma, emaBarCount);
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        Num massIndex = this.numOf(0);
        for (int i = startIndex; i <= index; ++i) {
            Num emaRatio = ((Num)this.singleEma.getValue(i)).dividedBy((Num)this.doubleEma.getValue(i));
            massIndex = massIndex.plus(emaRatio);
        }
        return massIndex;
    }
}

