/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.EMAIndicator;
import org.ta4j.core.num.Num;

public class MACDIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = -6899062131135971403L;
    private final EMAIndicator shortTermEma;
    private final EMAIndicator longTermEma;

    public MACDIndicator(Indicator<Num> indicator) {
        this(indicator, 12, 26);
    }

    public MACDIndicator(Indicator<Num> indicator, int shortBarCount, int longBarCount) {
        super(indicator);
        if (shortBarCount > longBarCount) {
            throw new IllegalArgumentException("Long term period count must be greater than short term period count");
        }
        this.shortTermEma = new EMAIndicator(indicator, shortBarCount);
        this.longTermEma = new EMAIndicator(indicator, longBarCount);
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.shortTermEma.getValue(index)).minus((Num)this.longTermEma.getValue(index));
    }
}

