/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class LWMAIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final int barCount;
    private final Num zero = this.numOf(0);

    public LWMAIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        int startIndex;
        Num sum = this.zero;
        Num denominator = this.zero;
        int count = 0;
        if (index + 1 < this.barCount) {
            return this.zero;
        }
        for (int i = startIndex = index - this.barCount + 1; i <= index; ++i) {
            denominator = denominator.plus(this.numOf(++count));
            sum = sum.plus(this.indicator.getValue(i).multipliedBy(this.numOf(count)));
        }
        return sum.dividedBy(denominator);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

