/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.num.Num;

public class KAMAIndicator
extends RecursiveCachedIndicator<Num> {
    private final Indicator<Num> price;
    private final int barCountEffectiveRatio;
    private final Num fastest;
    private final Num slowest;

    public KAMAIndicator(Indicator<Num> price, int barCountEffectiveRatio, int barCountFast, int barCountSlow) {
        super(price);
        this.price = price;
        this.barCountEffectiveRatio = barCountEffectiveRatio;
        this.fastest = this.numOf(2).dividedBy(this.numOf(barCountFast + 1));
        this.slowest = this.numOf(2).dividedBy(this.numOf(barCountSlow + 1));
    }

    public KAMAIndicator(Indicator<Num> price) {
        this(price, 10, 2, 30);
    }

    @Override
    protected Num calculate(int index) {
        Num currentPrice = this.price.getValue(index);
        if (index < this.barCountEffectiveRatio) {
            return currentPrice;
        }
        int startChangeIndex = Math.max(0, index - this.barCountEffectiveRatio);
        Num change = currentPrice.minus(this.price.getValue(startChangeIndex)).abs();
        Num volatility = this.numOf(0);
        for (int i = startChangeIndex; i < index; ++i) {
            volatility = volatility.plus(this.price.getValue(i + 1).minus(this.price.getValue(i)).abs());
        }
        Num er = change.dividedBy(volatility);
        Num sc = er.multipliedBy(this.fastest.minus(this.slowest)).plus(this.slowest).pow(2);
        Num priorKAMA = (Num)this.getValue(index - 1);
        return priorKAMA.plus(sc.multipliedBy(currentPrice.minus(priorKAMA)));
    }
}

