/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.WMAIndicator;
import org.ta4j.core.indicators.helpers.DifferenceIndicator;
import org.ta4j.core.indicators.helpers.MultiplierIndicator;
import org.ta4j.core.num.Num;

public class HMAIndicator
extends CachedIndicator<Num> {
    private final int barCount;
    private final WMAIndicator sqrtWma;

    public HMAIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.barCount = barCount;
        WMAIndicator halfWma = new WMAIndicator(indicator, barCount / 2);
        WMAIndicator origWma = new WMAIndicator(indicator, barCount);
        DifferenceIndicator indicatorForSqrtWma = new DifferenceIndicator(new MultiplierIndicator(halfWma, 2.0), origWma);
        this.sqrtWma = new WMAIndicator(indicatorForSqrtWma, this.numOf(barCount).sqrt().intValue());
    }

    @Override
    protected Num calculate(int index) {
        return (Num)this.sqrtWma.getValue(index);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

