/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.indicators.helpers.MedianPriceIndicator;
import org.ta4j.core.num.Num;

public class FisherIndicator
extends RecursiveCachedIndicator<Num> {
    private static final long serialVersionUID = 4622250625267906228L;
    private static final double ZERO_DOT_FIVE = 0.5;
    private static final double VALUE_MAX = 0.999;
    private static final double VALUE_MIN = -0.999;
    private final Indicator<Num> ref;
    private final Indicator<Num> intermediateValue;
    private final Num densityFactor;
    private final Num gamma;
    private final Num delta;

    public FisherIndicator(BarSeries series) {
        this(new MedianPriceIndicator(series), 10);
    }

    public FisherIndicator(Indicator<Num> price, int barCount) {
        this(price, barCount, 0.33, 0.67, 0.5, 0.5, 1.0, true);
    }

    public FisherIndicator(Indicator<Num> price, int barCount, double alpha, double beta) {
        this(price, barCount, alpha, beta, 0.5, 0.5, 1.0, true);
    }

    public FisherIndicator(Indicator<Num> price, int barCount, double alpha, double beta, double gamma, double delta) {
        this(price, barCount, alpha, beta, gamma, delta, 1.0, true);
    }

    public FisherIndicator(Indicator<Num> ref, int barCount, boolean isPriceIndicator) {
        this(ref, barCount, 0.33, 0.67, 0.5, 0.5, 1.0, isPriceIndicator);
    }

    public FisherIndicator(Indicator<Num> ref, int barCount, double densityFactor, boolean isPriceIndicator) {
        this(ref, barCount, 0.33, 0.67, 0.5, 0.5, densityFactor, isPriceIndicator);
    }

    public FisherIndicator(Indicator<Num> ref, int barCount, double alphaD, double betaD, double gammaD, double deltaD, double densityFactorD, boolean isPriceIndicator) {
        super(ref);
        this.ref = ref;
        this.gamma = this.numOf(gammaD);
        this.delta = this.numOf(deltaD);
        this.densityFactor = this.numOf(densityFactorD);
        final Num alpha = this.numOf(alphaD);
        final Num beta = this.numOf(betaD);
        final HighestValueIndicator periodHigh = new HighestValueIndicator(isPriceIndicator ? new HighPriceIndicator(ref.getBarSeries()) : ref, barCount);
        final LowestValueIndicator periodLow = new LowestValueIndicator(isPriceIndicator ? new LowPriceIndicator(ref.getBarSeries()) : ref, barCount);
        this.intermediateValue = new RecursiveCachedIndicator<Num>((Indicator)ref){
            private static final long serialVersionUID = 1242564751445450654L;

            @Override
            protected Num calculate(int index) {
                if (index <= 0) {
                    return this.numOf(0);
                }
                Num currentRef = (Num)FisherIndicator.this.ref.getValue(index);
                Num minL = (Num)periodLow.getValue(index);
                Num maxH = (Num)periodHigh.getValue(index);
                Num term1 = currentRef.minus(minL).dividedBy(maxH.minus(minL)).minus(this.numOf(0.5));
                Num term2 = alpha.multipliedBy(this.numOf(2)).multipliedBy(term1);
                Num term3 = term2.plus(beta.multipliedBy((Num)this.getValue(index - 1)));
                return term3.dividedBy(FisherIndicator.this.densityFactor);
            }
        };
    }

    @Override
    protected Num calculate(int index) {
        if (index <= 0) {
            return this.numOf(0);
        }
        Num value = this.intermediateValue.getValue(index);
        if (value.isGreaterThan(this.numOf(0.999))) {
            value = this.numOf(0.999);
        } else if (value.isLessThan(this.numOf(-0.999))) {
            value = this.numOf(-0.999);
        }
        Num term1 = this.numOf(Math.log(this.numOf(1).plus(value).dividedBy(this.numOf(1).minus(value)).doubleValue()));
        Num term2 = (Num)this.getValue(index - 1);
        return this.gamma.multipliedBy(term1).plus(this.delta.multipliedBy(term2));
    }
}

