/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.indicators.helpers.ClosePriceIndicator;
import org.ta4j.core.num.Num;

public class DPOIndicator
extends CachedIndicator<Num> {
    private final int barCount;
    private final int timeShift;
    private final Indicator<Num> price;
    private final SMAIndicator sma;

    public DPOIndicator(BarSeries series, int barCount) {
        this(new ClosePriceIndicator(series), barCount);
    }

    public DPOIndicator(Indicator<Num> price, int barCount) {
        super(price);
        this.barCount = barCount;
        this.timeShift = barCount / 2 + 1;
        this.price = price;
        this.sma = new SMAIndicator(price, this.barCount);
    }

    @Override
    protected Num calculate(int index) {
        return this.price.getValue(index).minus((Num)this.sma.getValue(index - this.timeShift));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

