/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.ATRIndicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.num.Num;

public class ChopIndicator
extends CachedIndicator<Num> {
    private final ATRIndicator atrIndicator;
    private final int timeFrame;
    private final Num LOG10n;
    private final HighestValueIndicator hvi;
    private final LowestValueIndicator lvi;
    private final Num scaleUpTo;

    public ChopIndicator(BarSeries barSeries, int ciTimeFrame, int scaleTo) {
        super(barSeries);
        this.atrIndicator = new ATRIndicator(barSeries, 1);
        this.hvi = new HighestValueIndicator(new HighPriceIndicator(barSeries), ciTimeFrame);
        this.lvi = new LowestValueIndicator(new LowPriceIndicator(barSeries), ciTimeFrame);
        this.timeFrame = ciTimeFrame;
        this.LOG10n = this.numOf(Math.log10(ciTimeFrame));
        this.scaleUpTo = this.numOf(scaleTo);
    }

    @Override
    public Num calculate(int index) {
        Num summ = (Num)this.atrIndicator.getValue(index);
        for (int i = 1; i < this.timeFrame; ++i) {
            summ = summ.plus((Num)this.atrIndicator.getValue(index - i));
        }
        Num a = summ.dividedBy(((Num)this.hvi.getValue(index)).minus((Num)this.lvi.getValue(index)));
        return this.scaleUpTo.multipliedBy(this.numOf(Math.log10(a.doubleValue()))).dividedBy(this.LOG10n);
    }
}

