/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.ATRIndicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.num.Num;

public class ChandelierExitShortIndicator
extends CachedIndicator<Num> {
    private final LowestValueIndicator low;
    private final ATRIndicator atr;
    private final Num k;

    public ChandelierExitShortIndicator(BarSeries series) {
        this(series, 22, 3.0);
    }

    public ChandelierExitShortIndicator(BarSeries series, int barCount, double k) {
        super(series);
        this.low = new LowestValueIndicator(new LowPriceIndicator(series), barCount);
        this.atr = new ATRIndicator(series, barCount);
        this.k = this.numOf(k);
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.low.getValue(index)).plus(((Num)this.atr.getValue(index)).multipliedBy(this.k));
    }
}

