/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.ATRIndicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.num.Num;

public class ChandelierExitLongIndicator
extends CachedIndicator<Num> {
    private final HighestValueIndicator high;
    private final ATRIndicator atr;
    private final Num k;

    public ChandelierExitLongIndicator(BarSeries series) {
        this(series, 22, 3.0);
    }

    public ChandelierExitLongIndicator(BarSeries series, int barCount, double k) {
        super(series);
        this.high = new HighestValueIndicator(new HighPriceIndicator(series), barCount);
        this.atr = new ATRIndicator(series, barCount);
        this.k = this.numOf(k);
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.high.getValue(index)).minus(((Num)this.atr.getValue(index)).multipliedBy(this.k));
    }
}

