/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.AbstractIndicator;

public abstract class CachedIndicator<T>
extends AbstractIndicator<T> {
    private static final long serialVersionUID = 7505855220893125595L;
    private final List<T> results = new ArrayList<T>();
    protected int highestResultIndex = -1;

    public CachedIndicator(BarSeries series) {
        super(series);
    }

    public CachedIndicator(Indicator<?> indicator) {
        this(indicator.getBarSeries());
    }

    @Override
    public T getValue(int index) {
        T result;
        BarSeries series = this.getBarSeries();
        if (series == null) {
            return this.calculate(index);
        }
        int removedBarsCount = series.getRemovedBarsCount();
        int maximumResultCount = series.getMaximumBarCount();
        if (index < removedBarsCount) {
            this.log.trace("{}: result from bar {} already removed from cache, use {}-th instead", new Object[]{this.getClass().getSimpleName(), index, removedBarsCount});
            this.increaseLengthTo(removedBarsCount, maximumResultCount);
            this.highestResultIndex = removedBarsCount;
            result = this.results.get(0);
            if (result == null) {
                result = this.calculate(0);
                this.results.set(0, result);
            }
        } else if (index == series.getEndIndex()) {
            result = this.calculate(index);
        } else {
            this.increaseLengthTo(index, maximumResultCount);
            if (index > this.highestResultIndex) {
                this.highestResultIndex = index;
                result = this.calculate(index);
                this.results.set(this.results.size() - 1, result);
            } else {
                int resultInnerIndex = this.results.size() - 1 - (this.highestResultIndex - index);
                result = this.results.get(resultInnerIndex);
                if (result == null) {
                    result = this.calculate(index);
                    this.results.set(resultInnerIndex, result);
                }
            }
        }
        return result;
    }

    protected abstract T calculate(int var1);

    private void increaseLengthTo(int index, int maxLength) {
        if (this.highestResultIndex > -1) {
            int newResultsCount = Math.min(index - this.highestResultIndex, maxLength);
            if (newResultsCount == maxLength) {
                this.results.clear();
                this.results.addAll(Collections.nCopies(maxLength, null));
            } else if (newResultsCount > 0) {
                this.results.addAll(Collections.nCopies(newResultsCount, null));
                this.removeExceedingResults(maxLength);
            }
        } else {
            assert (this.results.isEmpty()) : "Cache results list should be empty";
            this.results.addAll(Collections.nCopies(Math.min(index + 1, maxLength), null));
        }
    }

    private void removeExceedingResults(int maximumResultCount) {
        int resultCount = this.results.size();
        if (resultCount > maximumResultCount) {
            int nbResultsToRemove = resultCount - maximumResultCount;
            for (int i = 0; i < nbResultsToRemove; ++i) {
                this.results.remove(0);
            }
        }
    }
}

