/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.GainIndicator;
import org.ta4j.core.indicators.helpers.LossIndicator;
import org.ta4j.core.num.Num;

public class CMOIndicator
extends CachedIndicator<Num> {
    private final GainIndicator gainIndicator;
    private final LossIndicator lossIndicator;
    private final int barCount;

    public CMOIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.gainIndicator = new GainIndicator(indicator);
        this.lossIndicator = new LossIndicator(indicator);
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        Num sumOfGains = this.numOf(0);
        for (int i = Math.max(1, index - this.barCount + 1); i <= index; ++i) {
            sumOfGains = sumOfGains.plus((Num)this.gainIndicator.getValue(i));
        }
        Num sumOfLosses = this.numOf(0);
        for (int i = Math.max(1, index - this.barCount + 1); i <= index; ++i) {
            sumOfLosses = sumOfLosses.plus((Num)this.lossIndicator.getValue(i));
        }
        return sumOfGains.minus(sumOfLosses).dividedBy(sumOfGains.plus(sumOfLosses)).multipliedBy(this.numOf(100));
    }
}

