/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.indicators.helpers.TypicalPriceIndicator;
import org.ta4j.core.indicators.statistics.MeanDeviationIndicator;
import org.ta4j.core.num.Num;

public class CCIIndicator
extends CachedIndicator<Num> {
    private final Num factor = this.numOf(0.015);
    private final TypicalPriceIndicator typicalPriceInd;
    private final SMAIndicator smaInd;
    private final MeanDeviationIndicator meanDeviationInd;
    private final int barCount;

    public CCIIndicator(BarSeries series, int barCount) {
        super(series);
        this.typicalPriceInd = new TypicalPriceIndicator(series);
        this.smaInd = new SMAIndicator(this.typicalPriceInd, barCount);
        this.meanDeviationInd = new MeanDeviationIndicator(this.typicalPriceInd, barCount);
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        Num typicalPrice = (Num)this.typicalPriceInd.getValue(index);
        Num typicalPriceAvg = (Num)this.smaInd.getValue(index);
        Num meanDeviation = (Num)this.meanDeviationInd.getValue(index);
        if (meanDeviation.isZero()) {
            return this.numOf(0);
        }
        return typicalPrice.minus(typicalPriceAvg).dividedBy(meanDeviation.multipliedBy(this.factor));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

