/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class AroonUpIndicator
extends CachedIndicator<Num> {
    private final int barCount;
    private final HighestValueIndicator highestMaxPriceIndicator;
    private final Indicator<Num> maxValueIndicator;
    private final Num hundred;

    public AroonUpIndicator(Indicator<Num> maxValueIndicator, int barCount) {
        super(maxValueIndicator);
        this.barCount = barCount;
        this.maxValueIndicator = maxValueIndicator;
        this.hundred = this.numOf(100);
        this.highestMaxPriceIndicator = new HighestValueIndicator(maxValueIndicator, barCount + 1);
    }

    public AroonUpIndicator(BarSeries series, int barCount) {
        this(new HighPriceIndicator(series), barCount);
    }

    @Override
    protected Num calculate(int index) {
        if (this.getBarSeries().getBar(index).getHighPrice().isNaN()) {
            return NaN.NaN;
        }
        int endIndex = Math.max(0, index - this.barCount);
        int nbBars = 0;
        for (int i = index; i > endIndex && !this.maxValueIndicator.getValue(i).isEqual((Num)this.highestMaxPriceIndicator.getValue(index)); --i) {
            ++nbBars;
        }
        return this.numOf(this.barCount - nbBars).dividedBy(this.numOf(this.barCount)).multipliedBy(this.hundred);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

