/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.AroonDownIndicator;
import org.ta4j.core.indicators.AroonUpIndicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class AroonOscillatorIndicator
extends CachedIndicator<Num> {
    private final AroonDownIndicator aroonDownIndicator;
    private final AroonUpIndicator aroonUpIndicator;
    private final int barCount;

    public AroonOscillatorIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
        this.aroonDownIndicator = new AroonDownIndicator(series, barCount);
        this.aroonUpIndicator = new AroonUpIndicator(series, barCount);
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.aroonUpIndicator.getValue(index)).minus((Num)this.aroonDownIndicator.getValue(index));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }

    public AroonDownIndicator getAroonDownIndicator() {
        return this.aroonDownIndicator;
    }

    public AroonUpIndicator getAroonUpIndicator() {
        return this.aroonUpIndicator;
    }
}

