/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class AroonDownIndicator
extends CachedIndicator<Num> {
    private final int barCount;
    private final LowestValueIndicator lowestMinPriceIndicator;
    private final Indicator<Num> minValueIndicator;
    private final Num hundred;

    public AroonDownIndicator(Indicator<Num> minValueIndicator, int barCount) {
        super(minValueIndicator);
        this.barCount = barCount;
        this.minValueIndicator = minValueIndicator;
        this.hundred = this.numOf(100);
        this.lowestMinPriceIndicator = new LowestValueIndicator(minValueIndicator, barCount + 1);
    }

    public AroonDownIndicator(BarSeries series, int barCount) {
        this(new LowPriceIndicator(series), barCount);
    }

    @Override
    protected Num calculate(int index) {
        if (this.getBarSeries().getBar(index).getLowPrice().isNaN()) {
            return NaN.NaN;
        }
        int endIndex = Math.max(0, index - this.barCount);
        int nbBars = 0;
        for (int i = index; i > endIndex && !this.minValueIndicator.getValue(i).isEqual((Num)this.lowestMinPriceIndicator.getValue(index)); --i) {
            ++nbBars;
        }
        return this.numOf(this.barCount - nbBars).dividedBy(this.numOf(this.barCount)).multipliedBy(this.hundred);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

