/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.num.Num;

public abstract class AbstractEMAIndicator
extends RecursiveCachedIndicator<Num> {
    private static final long serialVersionUID = -7312565662007443461L;
    private final Indicator<Num> indicator;
    private final int barCount;
    private final Num multiplier;

    public AbstractEMAIndicator(Indicator<Num> indicator, int barCount, double multiplier) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
        this.multiplier = this.numOf(multiplier);
    }

    @Override
    protected Num calculate(int index) {
        if (index == 0) {
            return this.indicator.getValue(0);
        }
        Num prevValue = (Num)this.getValue(index - 1);
        return this.indicator.getValue(index).minus(prevValue).multipliedBy(this.multiplier).plus(prevValue);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

