/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.cost;

import org.ta4j.core.Order;
import org.ta4j.core.Trade;
import org.ta4j.core.cost.CostModel;
import org.ta4j.core.num.Num;

public class LinearTransactionCostModel
implements CostModel {
    private double feePerTrade;

    public LinearTransactionCostModel(double feePerTrade) {
        this.feePerTrade = feePerTrade;
    }

    @Override
    public Num calculate(Trade trade, int currentIndex) {
        return this.calculate(trade);
    }

    @Override
    public Num calculate(Trade trade) {
        Num totalTradeCost = null;
        Order entryOrder = trade.getEntry();
        if (entryOrder != null) {
            totalTradeCost = entryOrder.getCost();
            if (trade.getExit() != null) {
                totalTradeCost = totalTradeCost.plus(trade.getExit().getCost());
            }
        }
        return totalTradeCost;
    }

    @Override
    public Num calculate(Num price, Num amount) {
        return amount.numOf(this.feePerTrade).multipliedBy(price).multipliedBy(amount);
    }

    @Override
    public boolean equals(CostModel otherModel) {
        boolean equality = false;
        if (this.getClass().equals(otherModel.getClass())) {
            equality = ((LinearTransactionCostModel)otherModel).feePerTrade == this.feePerTrade;
        }
        return equality;
    }
}

