/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.cost;

import org.ta4j.core.Order;
import org.ta4j.core.Trade;
import org.ta4j.core.cost.CostModel;
import org.ta4j.core.num.Num;

public class LinearBorrowingCostModel
implements CostModel {
    private double feePerPeriod;

    public LinearBorrowingCostModel(double feePerPeriod) {
        this.feePerPeriod = feePerPeriod;
    }

    @Override
    public Num calculate(Num price, Num amount) {
        return price.numOf(0);
    }

    @Override
    public Num calculate(Trade trade) {
        if (trade.isOpened()) {
            throw new IllegalArgumentException("Trade is not closed. Final index of observation needs to be provided.");
        }
        return this.calculate(trade, trade.getExit().getIndex());
    }

    @Override
    public Num calculate(Trade trade, int currentIndex) {
        Order entryOrder = trade.getEntry();
        Order exitOrder = trade.getExit();
        Num borrowingCost = trade.getEntry().getNetPrice().numOf(0);
        if (entryOrder != null && entryOrder.getType().equals((Object)Order.OrderType.SELL) && entryOrder.getAmount() != null) {
            int tradingPeriods = 0;
            if (trade.isClosed()) {
                tradingPeriods = exitOrder.getIndex() - entryOrder.getIndex();
            } else if (trade.isOpened()) {
                tradingPeriods = currentIndex - entryOrder.getIndex();
            }
            borrowingCost = this.getHoldingCostForPeriods(tradingPeriods, trade.getEntry().getValue());
        }
        return borrowingCost;
    }

    private Num getHoldingCostForPeriods(int tradingPeriods, Num tradedValue) {
        return tradedValue.multipliedBy(tradedValue.numOf(tradingPeriods).multipliedBy(tradedValue.numOf(this.feePerPeriod)));
    }

    @Override
    public boolean equals(CostModel otherModel) {
        boolean equality = false;
        if (this.getClass().equals(otherModel.getClass())) {
            equality = ((LinearBorrowingCostModel)otherModel).feePerPeriod == this.feePerPeriod;
        }
        return equality;
    }
}

