/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.AnalysisCriterion;
import org.ta4j.core.BarSeries;
import org.ta4j.core.BaseTradingRecord;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class VersusBuyAndHoldCriterion
extends AbstractAnalysisCriterion {
    private AnalysisCriterion criterion;

    public VersusBuyAndHoldCriterion(AnalysisCriterion criterion) {
        this.criterion = criterion;
    }

    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        BaseTradingRecord fakeRecord = new BaseTradingRecord();
        fakeRecord.enter(series.getBeginIndex());
        fakeRecord.exit(series.getEndIndex());
        return this.criterion.calculate(series, tradingRecord).dividedBy(this.criterion.calculate(series, fakeRecord));
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        BaseTradingRecord fakeRecord = new BaseTradingRecord();
        fakeRecord.enter(series.getBeginIndex());
        fakeRecord.exit(series.getEndIndex());
        return this.criterion.calculate(series, trade).dividedBy(this.criterion.calculate(series, fakeRecord));
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }
}

