/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import java.util.Collections;
import java.util.List;
import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.Returns;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class ValueAtRiskCriterion
extends AbstractAnalysisCriterion {
    private final Double confidence;

    public ValueAtRiskCriterion(Double confidence) {
        this.confidence = confidence;
    }

    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        Returns returns = new Returns(series, tradingRecord, Returns.ReturnType.LOG);
        return ValueAtRiskCriterion.calculateVaR(returns, this.confidence);
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        if (trade != null && trade.isClosed()) {
            Returns returns = new Returns(series, trade, Returns.ReturnType.LOG);
            return ValueAtRiskCriterion.calculateVaR(returns, this.confidence);
        }
        return series.numOf(0);
    }

    private static Num calculateVaR(Returns returns, double confidence) {
        Num zero = returns.numOf(0);
        List<Num> returnRates = returns.getValues().subList(1, returns.getSize() + 1);
        Num var = zero;
        if (!returnRates.isEmpty()) {
            int nInBody = (int)((double)returns.getSize() * confidence);
            int nInTail = returns.getSize() - nInBody;
            Collections.sort(returnRates);
            var = returnRates.get(nInTail - 1);
            if (var.isGreaterThan(zero)) {
                var = zero;
            }
        }
        return var;
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }
}

