/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class TotalProfitCriterion
extends AbstractAnalysisCriterion {
    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        return tradingRecord.getTrades().stream().map(trade -> this.calculateProfit(series, (Trade)trade)).reduce(series.numOf(1), Num::multipliedBy);
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        return this.calculateProfit(series, trade);
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }

    private Num calculateProfit(BarSeries series, Trade trade) {
        Num profit = series.numOf(1);
        if (trade.isClosed()) {
            Num exitClosePrice = trade.getExit().getNetPrice().isNaN() ? series.getBar(trade.getExit().getIndex()).getClosePrice() : trade.getExit().getNetPrice();
            Num entryClosePrice = trade.getEntry().getNetPrice().isNaN() ? series.getBar(trade.getEntry().getIndex()).getClosePrice() : trade.getEntry().getNetPrice();
            profit = trade.getEntry().isBuy() ? exitClosePrice.dividedBy(entryClosePrice) : entryClosePrice.dividedBy(exitClosePrice);
        }
        return profit;
    }
}

