/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class TotalProfit2Criterion
extends AbstractAnalysisCriterion {
    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        return tradingRecord.getTrades().stream().filter(Trade::isClosed).map(trade -> this.calculate(series, (Trade)trade)).reduce(series.numOf(0), Num::plus);
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        if (trade.isClosed()) {
            Num entryPrice;
            Num exitPrice = series.getBar(trade.getExit().getIndex()).getClosePrice();
            Num profit = exitPrice.minus(entryPrice = series.getBar(trade.getEntry().getIndex()).getClosePrice()).multipliedBy(trade.getExit().getAmount());
            return profit.isPositive() ? profit : series.numOf(0);
        }
        return series.numOf(0);
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }
}

