/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.AnalysisCriterion;
import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.analysis.criteria.MaximumDrawdownCriterion;
import org.ta4j.core.analysis.criteria.TotalProfitCriterion;
import org.ta4j.core.num.Num;

public class RewardRiskRatioCriterion
extends AbstractAnalysisCriterion {
    private AnalysisCriterion totalProfit = new TotalProfitCriterion();
    private AnalysisCriterion maxDrawdown = new MaximumDrawdownCriterion();

    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        return this.totalProfit.calculate(series, tradingRecord).dividedBy(this.maxDrawdown.calculate(series, tradingRecord));
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        return this.totalProfit.calculate(series, trade).dividedBy(this.maxDrawdown.calculate(series, trade));
    }
}

