/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class NumberOfBarsCriterion
extends AbstractAnalysisCriterion {
    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        return tradingRecord.getTrades().stream().filter(Trade::isClosed).map(t -> this.calculate(series, (Trade)t)).reduce(series.numOf(0), Num::plus);
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        if (trade.isClosed()) {
            int exitIndex = trade.getExit().getIndex();
            int entryIndex = trade.getEntry().getIndex();
            return series.numOf(exitIndex - entryIndex + 1);
        }
        return series.numOf(0);
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isLessThan(criterionValue2);
    }
}

