/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.CashFlow;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class MaximumDrawdownCriterion
extends AbstractAnalysisCriterion {
    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        CashFlow cashFlow = new CashFlow(series, tradingRecord);
        return this.calculateMaximumDrawdown(series, cashFlow);
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        if (trade != null && trade.getEntry() != null && trade.getExit() != null) {
            CashFlow cashFlow = new CashFlow(series, trade);
            return this.calculateMaximumDrawdown(series, cashFlow);
        }
        return series.numOf(0);
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isLessThan(criterionValue2);
    }

    private Num calculateMaximumDrawdown(BarSeries series, CashFlow cashFlow) {
        Num maximumDrawdown = series.numOf(0);
        Num maxPeak = series.numOf(0);
        if (!series.isEmpty()) {
            for (int i = series.getBeginIndex(); i <= series.getEndIndex(); ++i) {
                Num drawdown;
                Num value = cashFlow.getValue(i);
                if (value.isGreaterThan(maxPeak)) {
                    maxPeak = value;
                }
                if (!(drawdown = maxPeak.minus(value).dividedBy(maxPeak)).isGreaterThan(maximumDrawdown)) continue;
                maximumDrawdown = drawdown;
            }
        }
        return maximumDrawdown;
    }
}

