/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Order;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.analysis.criteria.TotalProfitCriterion;
import org.ta4j.core.num.Num;

public class LinearTransactionCostCriterion
extends AbstractAnalysisCriterion {
    private double initialAmount;
    private double a;
    private double b;
    private TotalProfitCriterion profit;

    public LinearTransactionCostCriterion(double initialAmount, double a) {
        this(initialAmount, a, 0.0);
    }

    public LinearTransactionCostCriterion(double initialAmount, double a, double b) {
        this.initialAmount = initialAmount;
        this.a = a;
        this.b = b;
        this.profit = new TotalProfitCriterion();
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        return this.getTradeCost(series, trade, series.numOf(this.initialAmount));
    }

    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        Num totalCosts = series.numOf(0);
        Num tradedAmount = series.numOf(this.initialAmount);
        for (Trade trade : tradingRecord.getTrades()) {
            Num tradeCost = this.getTradeCost(series, trade, tradedAmount);
            totalCosts = totalCosts.plus(tradeCost);
            tradedAmount = tradedAmount.minus(this.getOrderCost(trade.getEntry(), tradedAmount));
            tradedAmount = tradedAmount.multipliedBy(this.profit.calculate(series, trade));
            tradedAmount = tradedAmount.minus(this.getOrderCost(trade.getExit(), tradedAmount));
        }
        Trade currentTrade = tradingRecord.getCurrentTrade();
        if (currentTrade.isOpened()) {
            totalCosts = totalCosts.plus(this.getOrderCost(currentTrade.getEntry(), tradedAmount));
        }
        return totalCosts;
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isLessThan(criterionValue2);
    }

    private Num getOrderCost(Order order, Num tradedAmount) {
        Num orderCost = tradedAmount.numOf(0);
        if (order != null) {
            return tradedAmount.numOf(this.a).multipliedBy(tradedAmount).plus(tradedAmount.numOf(this.b));
        }
        return orderCost;
    }

    private Num getTradeCost(BarSeries series, Trade trade, Num initialAmount) {
        Num totalTradeCost = series.numOf(0);
        if (trade != null && trade.getEntry() != null) {
            totalTradeCost = this.getOrderCost(trade.getEntry(), initialAmount);
            if (trade.getExit() != null) {
                Num newTradedAmount = initialAmount.minus(totalTradeCost).multipliedBy(this.profit.calculate(series, trade));
                totalTradeCost = totalTradeCost.plus(this.getOrderCost(trade.getExit(), newTradedAmount));
            }
        }
        return totalTradeCost;
    }
}

