/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import java.util.Collections;
import java.util.List;
import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.Returns;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class ExpectedShortfallCriterion
extends AbstractAnalysisCriterion {
    private final Double confidence;

    public ExpectedShortfallCriterion(Double confidence) {
        this.confidence = confidence;
    }

    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        Returns returns = new Returns(series, tradingRecord, Returns.ReturnType.LOG);
        return ExpectedShortfallCriterion.calculateES(returns, this.confidence);
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        if (trade != null && trade.getEntry() != null && trade.getExit() != null) {
            Returns returns = new Returns(series, trade, Returns.ReturnType.LOG);
            return ExpectedShortfallCriterion.calculateES(returns, this.confidence);
        }
        return series.numOf(0);
    }

    private static Num calculateES(Returns returns, double confidence) {
        Num zero;
        List<Num> returnRates = returns.getValues().subList(1, returns.getSize() + 1);
        Num expectedShortfall = zero = returns.numOf(0);
        if (!returnRates.isEmpty()) {
            int nInBody = (int)((double)returns.getSize() * confidence);
            int nInTail = returns.getSize() - nInBody;
            Collections.sort(returnRates);
            List<Num> tailEvents = returnRates.subList(0, nInTail);
            Num sum = zero;
            for (int i = 0; i < nInTail; ++i) {
                sum = sum.plus(tailEvents.get(i));
            }
            expectedShortfall = sum.dividedBy(returns.numOf(nInTail));
            if (expectedShortfall.isGreaterThan(zero)) {
                expectedShortfall = zero;
            }
        }
        return expectedShortfall;
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }
}

