/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.num.Num;

public class AverageProfitableTradesCriterion
extends AbstractAnalysisCriterion {
    @Override
    public Num calculate(BarSeries series, Trade trade) {
        return this.isProfitableTrade(series, trade) ? series.numOf(1) : series.numOf(0);
    }

    private boolean isProfitableTrade(BarSeries series, Trade trade) {
        if (trade.isClosed()) {
            Num result = this.calculateResult(series, trade);
            return result.isGreaterThan(series.numOf(1));
        }
        return false;
    }

    private Num calculateResult(BarSeries series, Trade trade) {
        int entryIndex = trade.getEntry().getIndex();
        int exitIndex = trade.getExit().getIndex();
        if (trade.getEntry().isBuy()) {
            return series.getBar(exitIndex).getClosePrice().dividedBy(series.getBar(entryIndex).getClosePrice());
        }
        return series.getBar(entryIndex).getClosePrice().dividedBy(series.getBar(exitIndex).getClosePrice());
    }

    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        long numberOfProfitable = tradingRecord.getTrades().stream().filter(t -> this.isProfitableTrade(series, (Trade)t)).count();
        return series.numOf(numberOfProfitable).dividedBy(series.numOf(tradingRecord.getTradeCount()));
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }
}

