/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis.criteria;

import org.ta4j.core.AnalysisCriterion;
import org.ta4j.core.BarSeries;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.AbstractAnalysisCriterion;
import org.ta4j.core.analysis.criteria.NumberOfBarsCriterion;
import org.ta4j.core.analysis.criteria.TotalProfitCriterion;
import org.ta4j.core.num.Num;

public class AverageProfitCriterion
extends AbstractAnalysisCriterion {
    private AnalysisCriterion totalProfit = new TotalProfitCriterion();
    private AnalysisCriterion numberOfBars = new NumberOfBarsCriterion();

    @Override
    public Num calculate(BarSeries series, TradingRecord tradingRecord) {
        Num bars = this.numberOfBars.calculate(series, tradingRecord);
        if (bars.isEqual(series.numOf(0))) {
            return series.numOf(1);
        }
        return this.totalProfit.calculate(series, tradingRecord).pow(series.numOf(1).dividedBy(bars));
    }

    @Override
    public Num calculate(BarSeries series, Trade trade) {
        Num bars = this.numberOfBars.calculate(series, trade);
        if (bars.isEqual(series.numOf(0))) {
            return series.numOf(1);
        }
        return this.totalProfit.calculate(series, trade).pow(series.numOf(1).dividedBy(bars));
    }

    @Override
    public boolean betterThan(Num criterionValue1, Num criterionValue2) {
        return criterionValue1.isGreaterThan(criterionValue2);
    }
}

