/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.CashFlow;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class Returns
implements Indicator<Num> {
    private final ReturnType type;
    private final BarSeries barSeries;
    private List<Num> values;
    private static Num one;

    public Returns(BarSeries barSeries, Trade trade, ReturnType type) {
        one = barSeries.numOf(1);
        this.barSeries = barSeries;
        this.type = type;
        this.values = new ArrayList<Num>(Collections.singletonList(NaN.NaN));
        this.calculate(trade);
        this.fillToTheEnd();
    }

    public Returns(BarSeries barSeries, TradingRecord tradingRecord, ReturnType type) {
        one = barSeries.numOf(1);
        this.barSeries = barSeries;
        this.type = type;
        this.values = new ArrayList<Num>(Collections.singletonList(NaN.NaN));
        this.calculate(tradingRecord);
        this.fillToTheEnd();
    }

    public List<Num> getValues() {
        return this.values;
    }

    @Override
    public Num getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public BarSeries getBarSeries() {
        return this.barSeries;
    }

    @Override
    public Num numOf(Number number) {
        return this.barSeries.numOf(number);
    }

    public int getSize() {
        return this.barSeries.getBarCount() - 1;
    }

    public void calculate(Trade trade) {
        this.calculate(trade, this.barSeries.getEndIndex());
    }

    public void calculate(Trade trade, int finalIndex) {
        Num assetReturn;
        boolean isLongTrade = trade.getEntry().isBuy();
        Num minusOne = this.barSeries.numOf(-1);
        int endIndex = CashFlow.determineEndIndex(trade, finalIndex, this.barSeries.getEndIndex());
        int entryIndex = trade.getEntry().getIndex();
        int begin = entryIndex + 1;
        if (begin > this.values.size()) {
            this.values.addAll(Collections.nCopies(begin - this.values.size(), this.barSeries.numOf(0)));
        }
        int startingIndex = Math.max(begin, 1);
        int nPeriods = endIndex - entryIndex;
        Num holdingCost = trade.getHoldingCost(endIndex);
        Num avgCost = holdingCost.dividedBy(holdingCost.numOf(nPeriods));
        Num lastPrice = trade.getEntry().getNetPrice();
        for (int i = startingIndex; i < endIndex; ++i) {
            Num intermediateNetPrice = CashFlow.addCost(this.barSeries.getBar(i).getClosePrice(), avgCost, isLongTrade);
            assetReturn = this.type.calculate(intermediateNetPrice, lastPrice);
            Num strategyReturn = trade.getEntry().isBuy() ? assetReturn : assetReturn.multipliedBy(minusOne);
            this.values.add(strategyReturn);
            lastPrice = this.barSeries.getBar(i).getClosePrice();
        }
        Num exitPrice = trade.getExit() != null ? trade.getExit().getNetPrice() : this.barSeries.getBar(endIndex).getClosePrice();
        assetReturn = this.type.calculate(CashFlow.addCost(exitPrice, avgCost, isLongTrade), lastPrice);
        Num strategyReturn = trade.getEntry().isBuy() ? assetReturn : assetReturn.multipliedBy(minusOne);
        this.values.add(strategyReturn);
    }

    private void calculate(TradingRecord tradingRecord) {
        tradingRecord.getTrades().forEach(this::calculate);
    }

    private void fillToTheEnd() {
        if (this.barSeries.getEndIndex() >= this.values.size()) {
            this.values.addAll(Collections.nCopies(this.barSeries.getEndIndex() - this.values.size() + 1, this.barSeries.numOf(0)));
        }
    }

    public static enum ReturnType {
        LOG{

            @Override
            public Num calculate(Num xNew, Num xOld) {
                return xNew.dividedBy(xOld).log();
            }
        }
        ,
        ARITHMETIC{

            @Override
            public Num calculate(Num xNew, Num xOld) {
                return xNew.dividedBy(xOld).minus(one);
            }
        };


        public abstract Num calculate(Num var1, Num var2);
    }
}

