/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.num.Num;

public class CashFlow
implements Indicator<Num> {
    private final BarSeries barSeries;
    private List<Num> values;

    public CashFlow(BarSeries barSeries, Trade trade) {
        this.barSeries = barSeries;
        this.values = new ArrayList<Num>(Collections.singletonList(this.numOf(1)));
        this.calculate(trade);
        this.fillToTheEnd();
    }

    public CashFlow(BarSeries barSeries, TradingRecord tradingRecord) {
        this.barSeries = barSeries;
        this.values = new ArrayList<Num>(Collections.singletonList(this.numOf(1)));
        this.calculate(tradingRecord);
        this.fillToTheEnd();
    }

    public CashFlow(BarSeries barSeries, TradingRecord tradingRecord, int finalIndex) {
        this.barSeries = barSeries;
        this.values = new ArrayList<Num>(Collections.singletonList(this.numOf(1)));
        this.calculate(tradingRecord, finalIndex);
        this.fillToTheEnd();
    }

    @Override
    public Num getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public BarSeries getBarSeries() {
        return this.barSeries;
    }

    @Override
    public Num numOf(Number number) {
        return this.barSeries.numOf(number);
    }

    public int getSize() {
        return this.barSeries.getBarCount();
    }

    private void calculate(Trade trade) {
        if (trade.isOpened()) {
            throw new IllegalArgumentException("Trade is not closed. Final index of observation needs to be provided.");
        }
        this.calculate(trade, trade.getExit().getIndex());
    }

    private void calculate(Trade trade, int finalIndex) {
        boolean isLongTrade = trade.getEntry().isBuy();
        int endIndex = CashFlow.determineEndIndex(trade, finalIndex, this.barSeries.getEndIndex());
        int entryIndex = trade.getEntry().getIndex();
        int begin = entryIndex + 1;
        if (begin > this.values.size()) {
            Num lastValue = this.values.get(this.values.size() - 1);
            this.values.addAll(Collections.nCopies(begin - this.values.size(), lastValue));
        }
        if (this.values.get(this.values.size() - 1).isGreaterThan(this.values.get(0).numOf(0))) {
            int startingIndex = Math.max(begin, 1);
            int nPeriods = endIndex - entryIndex;
            Num holdingCost = trade.getHoldingCost(endIndex);
            Num avgCost = holdingCost.dividedBy(holdingCost.numOf(nPeriods));
            Num netEntryPrice = trade.getEntry().getNetPrice();
            for (int i = startingIndex; i < endIndex; ++i) {
                Num intermediateNetPrice = CashFlow.addCost(this.barSeries.getBar(i).getClosePrice(), avgCost, isLongTrade);
                Num ratio = CashFlow.getIntermediateRatio(isLongTrade, netEntryPrice, intermediateNetPrice);
                this.values.add(this.values.get(entryIndex).multipliedBy(ratio));
            }
            Num exitPrice = trade.getExit() != null ? trade.getExit().getNetPrice() : this.barSeries.getBar(endIndex).getClosePrice();
            Num ratio = CashFlow.getIntermediateRatio(isLongTrade, netEntryPrice, CashFlow.addCost(exitPrice, avgCost, isLongTrade));
            this.values.add(this.values.get(entryIndex).multipliedBy(ratio));
        }
    }

    private static Num getIntermediateRatio(boolean isLongTrade, Num entryPrice, Num exitPrice) {
        Num ratio = isLongTrade ? exitPrice.dividedBy(entryPrice) : entryPrice.numOf(2).minus(exitPrice.dividedBy(entryPrice));
        return ratio;
    }

    private void calculate(TradingRecord tradingRecord) {
        tradingRecord.getTrades().forEach(this::calculate);
    }

    private void calculate(TradingRecord tradingRecord, int finalIndex) {
        this.calculate(tradingRecord);
        if (tradingRecord.getCurrentTrade().isOpened()) {
            this.calculate(tradingRecord.getCurrentTrade(), finalIndex);
        }
    }

    static Num addCost(Num rawPrice, Num holdingCost, boolean isLongTrade) {
        Num netPrice = isLongTrade ? rawPrice.minus(holdingCost) : rawPrice.plus(holdingCost);
        return netPrice;
    }

    private void fillToTheEnd() {
        if (this.barSeries.getEndIndex() >= this.values.size()) {
            Num lastValue = this.values.get(this.values.size() - 1);
            this.values.addAll(Collections.nCopies(this.barSeries.getEndIndex() - this.values.size() + 1, lastValue));
        }
    }

    static int determineEndIndex(Trade trade, int finalIndex, int maxIndex) {
        int idx = finalIndex;
        if (trade.getExit() != null) {
            idx = Math.min(trade.getExit().getIndex(), finalIndex);
        }
        if (idx > maxIndex) {
            idx = maxIndex;
        }
        return idx;
    }
}

