/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.aggregator;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.ta4j.core.Bar;
import org.ta4j.core.BaseBar;
import org.ta4j.core.aggregator.BarAggregator;
import org.ta4j.core.num.Num;

public class DurationBarAggregator
implements BarAggregator {
    private final Duration timePeriod;
    private final boolean onlyFinalBars;

    public DurationBarAggregator(Duration timePeriod) {
        this(timePeriod, true);
    }

    public DurationBarAggregator(Duration timePeriod, boolean onlyFinalBars) {
        this.timePeriod = timePeriod;
        this.onlyFinalBars = onlyFinalBars;
    }

    @Override
    public List<Bar> aggregate(List<Bar> bars) {
        boolean isMultiplication;
        ArrayList<Bar> aggregated = new ArrayList<Bar>();
        if (bars.isEmpty()) {
            return aggregated;
        }
        Duration actualDur = bars.iterator().next().getTimePeriod();
        boolean bl = isMultiplication = this.timePeriod.getSeconds() % actualDur.getSeconds() == 0L;
        if (!isMultiplication) {
            throw new IllegalArgumentException("Cannot aggregate bars: the new timePeriod must be a multiplication of the actual timePeriod.");
        }
        int i = 0;
        Num zero = bars.iterator().next().getOpenPrice().numOf(0);
        while (i < bars.size()) {
            Bar bar = bars.get(i);
            ZonedDateTime beginTime = bar.getBeginTime();
            Num open = bar.getOpenPrice();
            Num high = bar.getHighPrice();
            Num low = bar.getLowPrice();
            Num close = null;
            Num volume = zero;
            Num amount = zero;
            Duration sumDur = Duration.ZERO;
            while (sumDur.compareTo(this.timePeriod) < 0) {
                if (i < bars.size()) {
                    bar = bars.get(i);
                    if (high == null || bar.getHighPrice().isGreaterThan(high)) {
                        high = bar.getHighPrice();
                    }
                    if (low == null || bar.getLowPrice().isLessThan(low)) {
                        low = bar.getLowPrice();
                    }
                    close = bar.getClosePrice();
                    volume = volume.plus(bar.getVolume());
                    amount = amount.plus(bar.getAmount());
                }
                sumDur = sumDur.plus(actualDur);
                ++i;
            }
            if (this.onlyFinalBars && i > bars.size()) continue;
            BaseBar aggregatedBar = new BaseBar(this.timePeriod, beginTime.plus(this.timePeriod), open, high, low, close, volume, amount);
            aggregated.add(aggregatedBar);
        }
        return aggregated;
    }
}

