/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.io.Serializable;
import java.util.List;
import org.ta4j.core.Order;
import org.ta4j.core.Trade;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public interface TradingRecord
extends Serializable {
    public Trade getCurrentTrade();

    default public void operate(int index) {
        this.operate(index, NaN.NaN, NaN.NaN);
    }

    public void operate(int var1, Num var2, Num var3);

    default public boolean enter(int index) {
        return this.enter(index, NaN.NaN, NaN.NaN);
    }

    public boolean enter(int var1, Num var2, Num var3);

    default public boolean exit(int index) {
        return this.exit(index, NaN.NaN, NaN.NaN);
    }

    public boolean exit(int var1, Num var2, Num var3);

    default public boolean isClosed() {
        return !this.getCurrentTrade().isOpened();
    }

    public List<Trade> getTrades();

    default public int getTradeCount() {
        return this.getTrades().size();
    }

    default public Trade getLastTrade() {
        List<Trade> trades = this.getTrades();
        if (!trades.isEmpty()) {
            return trades.get(trades.size() - 1);
        }
        return null;
    }

    public Order getLastOrder();

    public Order getLastOrder(Order.OrderType var1);

    public Order getLastEntry();

    public Order getLastExit();
}

