/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core;

import java.io.Serializable;
import java.util.Objects;
import org.ta4j.core.Order;
import org.ta4j.core.cost.CostModel;
import org.ta4j.core.cost.ZeroCostModel;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class Trade
implements Serializable {
    private static final long serialVersionUID = -5484709075767220358L;
    private Order entry;
    private Order exit;
    private Order.OrderType startingType;
    private CostModel transactionCostModel;
    private CostModel holdingCostModel;

    public Trade() {
        this(Order.OrderType.BUY);
    }

    public Trade(Order.OrderType startingType) {
        this(startingType, new ZeroCostModel(), new ZeroCostModel());
    }

    public Trade(Order.OrderType startingType, CostModel transactionCostModel, CostModel holdingCostModel) {
        if (startingType == null) {
            throw new IllegalArgumentException("Starting type must not be null");
        }
        this.startingType = startingType;
        this.transactionCostModel = transactionCostModel;
        this.holdingCostModel = holdingCostModel;
    }

    public Trade(Order entry, Order exit) {
        this(entry, exit, entry.getCostModel(), new ZeroCostModel());
    }

    public Trade(Order entry, Order exit, CostModel transactionCostModel, CostModel holdingCostModel) {
        if (entry.getType().equals((Object)exit.getType())) {
            throw new IllegalArgumentException("Both orders must have different types");
        }
        if (!entry.getCostModel().equals(transactionCostModel) || !exit.getCostModel().equals(transactionCostModel)) {
            throw new IllegalArgumentException("Orders and the trade must incorporate the same trading cost model");
        }
        this.startingType = entry.getType();
        this.entry = entry;
        this.exit = exit;
        this.transactionCostModel = transactionCostModel;
        this.holdingCostModel = holdingCostModel;
    }

    public Order getEntry() {
        return this.entry;
    }

    public Order getExit() {
        return this.exit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Trade) {
            Trade t = (Trade)obj;
            return (this.entry == null ? t.getEntry() == null : this.entry.equals(t.getEntry())) && (this.exit == null ? t.getExit() == null : this.exit.equals(t.getExit()));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.exit);
    }

    public Order operate(int index) {
        return this.operate(index, NaN.NaN, NaN.NaN);
    }

    public Order operate(int index, Num price, Num amount) {
        Order order = null;
        if (this.isNew()) {
            this.entry = order = new Order(index, this.startingType, price, amount, this.transactionCostModel);
        } else if (this.isOpened()) {
            if (index < this.entry.getIndex()) {
                throw new IllegalStateException("The index i is less than the entryOrder index");
            }
            this.exit = order = new Order(index, this.startingType.complementType(), price, amount, this.transactionCostModel);
        }
        return order;
    }

    public boolean isClosed() {
        return this.entry != null && this.exit != null;
    }

    public boolean isOpened() {
        return this.entry != null && this.exit == null;
    }

    public boolean isNew() {
        return this.entry == null && this.exit == null;
    }

    public String toString() {
        return "Entry: " + this.entry + " exit: " + this.exit;
    }

    public Num getProfit() {
        Num profit = this.isOpened() ? this.entry.getNetPrice().numOf(0) : this.calculateGrossProfit(this.exit.getPricePerAsset()).minus(this.getTradeCost());
        return profit;
    }

    public Num getProfit(int finalIndex, Num finalPrice) {
        Num grossProfit = this.calculateGrossProfit(finalPrice);
        return grossProfit.minus(this.getTradeCost(finalIndex));
    }

    private Num calculateGrossProfit(Num finalPrice) {
        Num grossProfit = this.isOpened() ? this.entry.getAmount().multipliedBy(finalPrice).minus(this.entry.getValue()) : this.exit.getValue().minus(this.entry.getValue());
        if (this.entry.getType().equals((Object)Order.OrderType.SELL)) {
            grossProfit = grossProfit.multipliedBy(this.entry.getNetPrice().numOf(-1));
        }
        return grossProfit;
    }

    public Num getTradeCost(int finalIndex) {
        Num transactionCost = this.transactionCostModel.calculate(this, finalIndex);
        Num borrowingCost = this.getHoldingCost(finalIndex);
        return transactionCost.plus(borrowingCost);
    }

    public Num getTradeCost() {
        Num transactionCost = this.transactionCostModel.calculate(this);
        Num borrowingCost = this.getHoldingCost();
        return transactionCost.plus(borrowingCost);
    }

    public Num getHoldingCost() {
        return this.holdingCostModel.calculate(this);
    }

    public Num getHoldingCost(int finalIndex) {
        return this.holdingCostModel.calculate(this, finalIndex);
    }
}

